<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\DependencyInjection;

use Cyber\OrmExtras\Doctrine\PrefixNamingStrategy;
use Cyber\OrmExtras\Supplier\CurrentUserSupplier;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class CyberOrmExtrasExtension extends Extension
{
    /**
     * @inheritdoc
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration();
        $config        = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $container->setAlias(CurrentUserSupplier::class, $config['user_supplier']);

        $container->setParameter('cyber.orm_extras.user_class', $config['user_class'] ?? null);
        $container->setParameter('cyber.orm_extras.id_field', $config['user_id_field']);
        $container->setParameter('cyber.orm_extras.default_id', $config['default_user_id'] ?? null);

        if (PHP_VERSION_ID >= 80000 && 'annotation' === $config['metadata_driver']) {
            trigger_deprecation(
                'cyber/audit-bundle',
                '6.1',
                'Using "annotation" cyber_orm_extras.metadata_driver is deprecated since version 6.1, switch to Attributes'
            );
        }

        if ('attribute' === $config['metadata_driver']) {
            $container->getDefinition(PrefixNamingStrategy::class)
                ->setArgument('$reader', null);
        }
    }
}
