<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Spec;

use Cyber\OrmExtras\Spec;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\Query;
use Doctrine\ORM\QueryBuilder;

class OnlyPage implements Spec
{
    /** @var int */
    private $page;

    /** @var int */
    private $perPage;

    /** @var null|Spec */
    private $parent;

    public function __construct(int $page, ?Spec $parent = null, int $perPage = 20)
    {
        $this->page    = $page;
        $this->perPage = $perPage;
        $this->parent  = $parent;
    }

    public function match(QueryBuilder $qb, string $dqlAlias)
    {
        if (null === $this->parent) {
            return null;
        }

        return $this->parent->match($qb, $dqlAlias);
    }

    /**
     * @param Query $query
     */
    public function modifyQuery(AbstractQuery $query): void
    {
        if (null !== $this->parent) {
            $this->parent->modifyQuery($query);
        }

        $query->setMaxResults($this->perPage);
        $query->setFirstResult($this->perPage * ($this->page - 1));
    }

    public function supports(string $className): bool
    {
        if (null === $this->parent) {
            return true;
        }

        return $this->parent->supports($className);
    }
}
