<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\OrmExtras\Spec;

use Cyber\OrmExtras\Spec;
use Cyber\OrmExtras\Spec\AsArray;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\Query;
use Doctrine\ORM\QueryBuilder;
use PHPUnit\Framework\TestCase;

class AsArrayTest extends TestCase
{
    /** @var AsArray */
    private $instance;

    /** @var \PHPUnit\Framework\MockObject\MockObject|Spec */
    private $parent;

    public function testSupports(): void
    {
        $this->parent->method('supports')
            ->withConsecutive([self::class], [TestCase::class])
            ->willReturnOnConsecutiveCalls(true, false);

        $this->assertTrue($this->instance->supports(self::class));
        $this->assertFalse($this->instance->supports(TestCase::class));
    }

    public function testMatch(): void
    {
        $qb = $this->getMockBuilder(QueryBuilder::class)->disableOriginalConstructor()->getMock();

        $expected = 'fromParent';
        $alias    = 'someAlias';

        $this->parent->expects(self::once())
            ->method('match')
            ->with($qb, $alias)
            ->willReturn($expected);

        $this->assertEquals($expected, $this->instance->match($qb, $alias));
    }

    public function testModifyQuery(): void
    {
        $query = $this->getMockBuilder(AbstractQuery::class)->disableOriginalConstructor()->getMock();
        $query->expects(self::once())
            ->method('setHydrationMode')
            ->with(Query::HYDRATE_ARRAY);

        $this->parent->expects(self::once())
            ->method('modifyQuery');

        $this->instance->modifyQuery($query);
    }

    protected function setUp(): void
    {
        $this->parent   = $this->getMockBuilder(Spec::class)->getMock();
        $this->instance = new AsArray($this->parent);
    }
}
