<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\OrmExtras\Supplier;

use Cyber\OrmExtras\Supplier\SupplierConfiguration;
use Cyber\OrmExtras\Supplier\UserLoader;
use PHPUnit\Framework\TestCase;
use Ramsey\Uuid\Uuid;
use Symfony\Component\HttpKernel\KernelInterface;
use Tests\Entity\User;

class UserLoaderTest extends TestCase
{
    /**
     * @SuppressWarnings(PHPMD.StaticAccess)
     */
    public function testUuidNormalization(): void
    {
        $kernel   = $this->createMock(KernelInterface::class);
        $config   = new SupplierConfiguration(User::class, 'id', 'system');
        $instance = new UserLoader($kernel, $config);

        $id = $instance->normalizeId(Uuid::uuid4());

        self::assertThat($id, $this->isType('string'));
    }
}
