The `MatchAgainst` allows you to use full text search.

## Configuration
To enable this function add the following to your configuration:

```yml
# Doctrine Configuration
doctrine:
    orm:
        dql:
            string_functions:
                match: Cyber\OrmExtras\Functions\MatchAgainst
```

## Sample Usage

### Getting relevance score
Let's take the following DQL:
```sql
SELECT MATCH(person.id) AGAINST (:againstParam) from \Tests\Cyber\OrmExtras\Fixtures\PersonEntity AS person;
```
Doctrine would convert it to:

```sql
SELECT MATCH (p0_.prs_id) AGAINST (?) FROM person p0_;
```
default search mode is NATURAL LANGUAGE mode [about modes](https://dev.mysql.com/doc/refman/5.7/en/fulltext-search.html)

### Boolean Full-Text Searches 
[about boolean search](https://dev.mysql.com/doc/refman/5.7/en/fulltext-boolean.html)
```sql
SELECT MATCH(person.id) AGAINST (:againstParam BOOLEAN) from \Tests\Cyber\OrmExtras\Fixtures\PersonEntity AS person;
```
Doctrine would convert it to:
```sql
SELECT MATCH (p0_.prs_id) AGAINST (? IN BOOLEAN MODE) FROM person p0_;
```
### Full-Text Searches with Query Expansion 
[about query expansion](https://dev.mysql.com/doc/refman/5.7/en/fulltext-query-expansion.html)
```sql
SELECT MATCH(person.id) AGAINST (:againstParam EXPAND) from \Tests\Cyber\OrmExtras\Fixtures\PersonEntity AS person;
```
Doctrine would convert it to:
```sql
SELECT MATCH (p0_.prs_id) AGAINST (?  WITH QUERY EXPANSION) FROM person p0_;
```

> You can combine BOOLEAN and EXPAND options

### Like and Full Text Search benchmark comparation

| EXAMPLE     | WORD%    | %WORD%    | WORD          | +*WOR*        | WORD       | +WOR*      |
|-------------|----------|-----------|---------------|---------------|------------|------------|
| DESCRIPTION | LIKE% OR | %LIKE% OR | NGRAM NATURAL | NGRAM BOOLEAN | FT NATURAL | FT BOOLEAN |
| 100 000     | 0.0246   | 0.0336    | 0.0433        | 0.1778        | 0.0413     | 0.0047     |
| 200 000     | 0.0504   | 0.0642    | 0.0051        | 0.7285        | 0.0055     | 0.0067     |
| 300 000     | 0.0729   | 0.0969    | 0.1357        | 1.8356        | 0.1336     | 0.0099     |
| 400 000     | 0.1094   | 0.1331    | 0.1849        | 3.3288        | 0.1796     | 0.0129     |
| 500 000     | 0.1186   | 0.161     | 0.2286        | 5.1521        | 0.227      | 0.0158     |
| 600 000     | 0.1686   | 0.218     | 0.2744        | 7.6795        | 0.2721     | 0.0193     |
| 700 000     | 0.1926   | 0.2592    | 0.3731        | 10.3153       | 0.3164     | 0.0296     |
| 800 000     | 0.2274   | 0.2975    | 0.3585        | 13.775        | 0.3548     | 0.0244     |
| 900 000     | 0.2691   | 0.338     | 0.427         | 15.9209       | 0.4257     | 0.0306     |
| 1000 000    | 0.2816   | 0.374     | 0.4742        | 20.8627       | 0.4742     | 0.0344     |
| 1100 000    | 0.3155   | 0.4203    | 0.5188        | 25.5099       | 0.5129     | 0.0381     |
| 1200 000    | 0.3432   | 0.4501    | 0.584         | 29.7876       | 0.5729     | 0.0424     |
| 1300 000    | 0.37     | 0.6159    | 0.6446        | 36.6783       | 0.6276     | 0.046      |
| 1400 000    | 0.3941   | 0.5253    | 0.658         | 42.4834       | 0.6566     | 0.05       |
| 1500 000    | 0.4404   | 0.5634    | 0.7055        | 47.2614       | 0.6646     | 0.0508     |
| 1600 000    | 0.4595   | 0.6115    | 0.7191        | 50.8332       | 0.7109     | 0.0541     |
| 1700 000    | 0.5191   | 0.6404    | 0.7823        | 58.1259       | 0.7794     | 0.0548     |
| 1800 000    | 0.5243   | 0.6759    | 0.8838        | 69.5244       | 0.8719     | 0.0644     |


All request was executed with SQL_NO_CACHE option, average time in the table calculate after 5 executions with different tags
All request search executed with two fields:

for LIKE request example "SELECT SQL_NO_CACHE count(*) from tableName where ((col1 like pattern) OR (col1 like pattern))"<br>

for MATCH AGAINST request example "SELECT SQL_NO_CACHE count(*) from tableName where MATCH(col1, col2) AGAINST('pattern' MODE)
