The `TablePrefix` annotation allows you to create ORM tables, that are complaint with ITSM Policy, without specifying field names in the annotations.

## Configuration

To enable this function add the following to your configuration:

```yaml
# Doctrine Configuration
doctrine:
    orm:
        naming_strategy: Cyber\OrmExtras\Doctrine\PrefixNamingStrategy
```

If you wish to use attribute instead of annotation, you have to specify the metadata_driver as `attribute`

```yaml
# Attribute configuration
cyber_orm_extras:
    metadata_driver: attribute

```

## Use Cases

The annotation is used for easy way to configure ORM Entities and to
follow [Policy & Procedures / Table Design](https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/Policies/Table-Design-Standards.md)
automatically.

## Sample Usage

### Entity

```php
<?php

/**
 * Class Person
 *
 * @ORM\Entity
 * @TablePrefix("psn")
 */
class Person
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     */
    protected $userDeleted;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    protected $dateDeleted;
```

#### Attribute Support

The `TablePrefix` can also be used as an attribute.

```php
<?php

#[ORM\Entity]
#[TablePrefix("psn")]
class Person
{
```

### SQL

Entity will be converted to following SQL:

```sql
CREATE TABLE person_entity
(
    psn_id              INTEGER NOT NULL,
    psn_user_deleted_id INTEGER  DEFAULT NULL,
    psn_date_deleted    DATETIME DEFAULT NULL,
    PRIMARY KEY (psn_id)
);
```

### Known limitations

#### Table with relationships and joined columns

For joined columns please use referencedColumnName property.
Example:
```php
     * @ORM\JoinColumn(referencedColumnName="usr_id")
```

## Notes
* For inheritance entities use only one annotation in parent entity. 
