<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

use DateTimeInterface;

trait EditorAttributeTrait
{
    /** @var mixed */
    protected $userEdited;

    protected ?DateTimeInterface $dateEdited = null;

    /**
     * @inheritDoc
     */
    public function getEditorCascade(): array
    {
        return [];
    }

    /**
     * @inheritDoc
     */
    public function getDateEdited(): ?\DateTimeInterface
    {
        return $this->dateEdited;
    }

    /**
     * @inheritDoc
     */
    public function setDateEdited(\DateTimeInterface $date): self
    {
        $this->dateEdited = $date;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getUserEdited()
    {
        return $this->userEdited;
    }

    /**
     * @inheritDoc
     */
    public function setUserEdited($user): self
    {
        $this->userEdited = $user;

        return $this;
    }
}
