<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Spec;

use Cyber\OrmExtras\Spec;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\QueryBuilder;

class OrX implements Spec
{
    /** @var Spec[] */
    private $children;

    public function __construct()
    {
        $this->children = \func_get_args();
    }

    /**
     * @inheritdoc
     */
    public function match(QueryBuilder $qb, string $dqlAlias)
    {
        $matches = \array_filter( // disregard empty ones
            \array_map( // map each spec to an Expr and combine them using orX into single Expr
                function (Spec $specification) use ($qb, $dqlAlias) {
                    return $specification->match($qb, $dqlAlias);
                },
                $this->children
            )
        );

        if (empty($matches)) {
            return null;
        }

        return \call_user_func_array([$qb->expr(), 'orX'], $matches);
    }

    /**
     * @inheritdoc
     */
    public function modifyQuery(AbstractQuery $query): void
    {
        foreach ($this->children as $child) {
            $child->modifyQuery($query);
        }
    }

    /**
     * @inheritdoc
     */
    public function supports(string $className): bool
    {
        foreach ($this->children as $child) {
            if (!$child->supports($className)) {
                return false;
            }
        }

        return true;
    }
}
