<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\OrmExtras\Functions;

use Cyber\OrmExtras\Functions\TypeFunction;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Platforms\AbstractPlatform;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Query;
use Doctrine\ORM\Query\Parser;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class TypeFunctionTest extends TestCase
{
    public function test(): void
    {
        $config = new Configuration();
        $config->addCustomStringFunction('type', TypeFunction::class);

        $platform = $this->getMockBuilder(AbstractPlatform::class)
            ->disableOriginalConstructor()
            ->getMock();

        if (\method_exists(AbstractPlatform::class, 'getSQLResultCasing')) {
            $platform->expects($this->any())
                ->method('getSQLResultCasing')
                ->willReturn('sclr_0');
        }

        $platform->expects($this->any())
            ->method('quoteIdentifier')
            ->willReturnArgument(0);

        $platform->expects($this->any())
            ->method('appendLockHint')
            ->willReturnArgument(0);

        $con = $this->getMockBuilder(Connection::class)
            ->disableOriginalConstructor()
            ->getMock();

        $con->expects($this->any())
            ->method('getDatabasePlatform')
            ->willReturn($platform);

        /** @var ClassMetadata<object>|MockObject $metadata */
        $metadata = $this->getMockBuilder(ClassMetadata::class)
            ->disableOriginalConstructor()
            ->getMock();

        $metadata->discriminatorColumn['name'] = 'some_name';
        $metadata->table['name']               = 'person';

        $metadata->expects($this->any())
            ->method('getTableName')
            ->willReturn('person');

        /** @var EntityManagerInterface|MockObject $em */
        $em = $this->getMockBuilder(EntityManagerInterface::class)
            ->getMock();
        $em->expects($this->any())
            ->method('getConfiguration')
            ->willReturn($config);

        $em->expects($this->any())
            ->method('getClassMetadata')
            ->willReturn($metadata);

        $em->expects($this->any())
            ->method('getConnection')
            ->willReturn($con);

        $query = new Query($em);
        $query->setDQL('SELECT TYPE(p) FROM \Tests\Cyber\OrmExtras\Fixtures\PersonEntity p');

        $parser = new Parser($query);
        $result = $parser->parse();

        $executor   = \method_exists($result, 'prepareSqlExecutor') ? $result->prepareSqlExecutor($query) : $result->getSqlExecutor();
        $statements = $executor->getSqlStatements();

        $this->assertEquals('SELECT p0_.some_name AS sclr_0 FROM person p0_', $statements);
    }
}
