<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\DependencyInjection;

use Cyber\OrmExtras\Supplier\CurrentUserSupplier;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class CyberOrmExtrasExtension extends Extension
{
    /**
     * @inheritdoc
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration();
        $config        = $this->processConfiguration($configuration, $configs);

        if(!isset($config['user_class'], $config['default_user_id'])) {
            // if we don't have required config, do not load anything.
            // user probably added the bundle but was not ready to configure it yet.
            return;
        }

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $loader->load('services.yml');

        $container->setAlias(CurrentUserSupplier::class, $config['user_supplier']);

        $container->setParameter('cyber.orm_extras.user_class', $config['user_class']);
        $container->setParameter('cyber.orm_extras.id_field', $config['user_id_field']);
        $container->setParameter('cyber.orm_extras.default_id', $config['default_user_id']);
        $container->setParameter('cyber.orm_extras.allowed_classes', $config['allowed_classes'] ?? null);
        $container->setParameter('cyber.orm_extras.use_immutable_dates', $config['use_immutable_dates']);
    }
}
