<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Filters;

use Cyber\OrmExtras\Utility\SoftDeletable;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Query\Filter\SQLFilter;

class SoftDeletedFilter extends SQLFilter
{
    /**
     * @var bool[]
     */
    protected $disabled = [];

    /**
     * @param ClassMetadata<object> $targetEntity
     * @param string                $targetTableAlias
     *
     * @return string
     */
    public function addFilterConstraint(ClassMetadata $targetEntity, $targetTableAlias): string
    {
        $class = $targetEntity->getName();
        if (\array_key_exists($class, $this->disabled) && true === $this->disabled[$class]) {
            return '';
        }

        if (\array_key_exists($targetEntity->rootEntityName, $this->disabled)
            && true === $this->disabled[$targetEntity->rootEntityName]) {
            return '';
        }

        if ($targetEntity->getReflectionClass()?->implementsInterface(SoftDeletable::class)) {
            $columnName = $targetEntity->getColumnName('dateDeleted');

            return $targetTableAlias . '.' . $columnName . ' IS NULL';
        }

        return '';
    }

    /**
     * @param string $class
     */
    public function disableForEntity($class): void
    {
        $this->disabled[$class] = true;
    }

    /**
     * @param string $class
     */
    public function enableForEntity($class): void
    {
        $this->disabled[$class] = false;
    }
}
