<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras;

use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\Query\Expr;
use Doctrine\ORM\QueryBuilder;

interface Spec
{
    /**
     * Adds matching logic to the query builder and returns and expression to be used in 'WHERE' clause.
     *
     * @param QueryBuilder $qb       the query builder used for matching
     * @param string       $dqlAlias the default entity alias for this matching operation
     *
     * @return null|Expr\Base|Expr\Comparison|Expr\Func|Expr\Math|string
     */
    public function match(QueryBuilder $qb, string $dqlAlias);

    /**
     * Adds modification to the Query generated by the QueryBuilder after applying the match() logic.
     *
     * @param AbstractQuery $query
     */
    public function modifyQuery(AbstractQuery $query): void;

    /**
     * @param class-string $className
     *
     * @return bool
     */
    public function supports(string $className): bool;
}
