<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\OrmExtras\Doctrine;

use Cyber\OrmExtras\Annotations\TablePrefix;
use Cyber\OrmExtras\Doctrine\PrefixNamingStrategy;
use PHPUnit\Framework\TestCase;

class PrefixNamingStrategyTest extends TestCase
{
    public function testAttributeDriver(): void
    {
        if (PHP_VERSION_ID < 80000) {
            self::markTestSkipped('Attributes not available prior to php8.0');
        }
        $instance = new PrefixNamingStrategy();
        $prefix   = $instance->findPrefix(GoodPrefix::class);
        self::assertEquals('abc', $prefix);
    }

    public function testPublicMethods(): void
    {
        if (PHP_VERSION_ID < 80000) {
            self::markTestSkipped('Attributes not available prior to php8.0');
        }
        $instance = new PrefixNamingStrategy();
        $name     = $instance->propertyToColumnName('prop', GoodPrefix::class);
        self::assertEquals('abc_prop', $name);

        $name = $instance->joinColumnName('prop', GoodPrefix::class);
        self::assertEquals('abc_prop_id', $name);

        $name = $instance->findPrefix(null);
        self::assertEquals('', $name);
    }
}

#[TablePrefix('abc')]
class GoodPrefix
{
}
