<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\OrmExtras\Spec;

use Cyber\OrmExtras\Spec;
use Cyber\OrmExtras\Spec\JoiningSpec;
use Doctrine\ORM\QueryBuilder;
use PHPUnit\Framework\TestCase;

class JoiningSpecTest extends TestCase
{
    /**
     * @SuppressWarnings(PHPMD.UnusedLocalVariable)
     */
    public function testJoiningSpec(): void
    {
        $qb         = $this->getMockBuilder(QueryBuilder::class)->disableOriginalConstructor()->getMock();
        $parentSpec = $this->getMockBuilder(Spec::class)->getMock();

        $joinCb = function ($joinQb, $alias) use ($qb) {
            $this->assertSame($qb, $joinQb);
            $this->assertEquals('main-alias', $alias);
        };

        $supportCb = function ($className) {
            $this->assertEquals(Spec::class, $className);

            return true;
        };

        $spec = new class($joinCb, $supportCb, $parentSpec) extends JoiningSpec {
            /** @var callable */
            private $joinCallback;

            /** @var callable */
            private $supportsCallback;

            protected $joinAlias = 'test-alias';

            protected $joinClass = JoiningSpecTest::class;

            public function __construct(callable $joinCb, callable $supportCb, Spec $parent)
            {
                parent::__construct($parent);

                $this->joinCallback     = $joinCb;
                $this->supportsCallback = $supportCb;
            }

            /**
             * @inheritdoc
             */
            public function joinMatch(QueryBuilder $qb, string $dqlAlias): void
            {
                ($this->joinCallback)($qb, $dqlAlias);
            }

            /**
             * @inheritdoc
             */
            public function joinSupports(string $className): bool
            {
                return ($this->supportsCallback)($className);
            }
        };

        $parentSpec->expects(self::once())
            ->method('match')
            ->with($qb, 'test-alias')
            ->willReturn('1=1');

        $parentSpec->expects(self::exactly(2))
            ->method('supports')
            ->with(self::class)
            ->willReturnOnConsecutiveCalls(true, false);

        $this->assertEquals('1=1', $spec->match($qb, 'main-alias'));
        $this->assertTrue($spec->supports(Spec::class));
        $this->assertFalse($spec->supports(Spec::class));
    }
}
