<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

use DateTimeInterface;

/**
 * @template TT
 */
trait CreatorAttributeTrait
{
    /**
     * @var null|TT
     */
    protected $userCreated;

    protected ?DateTimeInterface $dateCreated = null;

    /**
     * @inheritDoc
     */
    public function getCreatorCascade(): array
    {
        return [];
    }

    /**
     * @inheritDoc
     */
    public function getDateCreated(): ?DateTimeInterface
    {
        return $this->dateCreated;
    }

    /**
     * @inheritDoc
     *
     * @return $this
     */
    public function setDateCreated(DateTimeInterface $date): self
    {
        $this->dateCreated = $date;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getUserCreated()
    {
        return $this->userCreated;
    }

    /**
     * @inheritDoc
     *
     * @return $this
     */
    public function setUserCreated($user): self
    {
        $this->userCreated = $user;

        return $this;
    }
}
