The `StringAgg` allows to execute aggregation functions in popular platforms.

## Configuration

To enable this function add the following to your configuration:

```yml
# Doctrine Configuration
doctrine:
    orm:
        dql:
            numeric_functions:
                regex: Cyber\OrmExtras\Functions\RegexFunction
```

> The key **regex** in the above configuration will actually be the function name you will have to use in DQL.
>
> You can call the function anyway you want, but for purposes of examples below it will be **regex**

## Sample Usage

The following DQL will perform regex matching on the username field.

```sql
SELECT ad FROM Tests\EntityMySql\UserProfile ad WHERE regex(ad.username, 'som_regex') = true;
```

> Be careful when using regexes. The evaluation could be platform dependent. For example, on postgres a REGEX value
> of `abc` is LIKE equivalent of `%abc%`.
> You must ensure proper indexing is configured for such searches to work fast.
