The `StringAgg` allows to execute aggregation functions in popular platforms.

## Configuration

To enable this function add the following to your configuration:

```yml
# Doctrine Configuration
doctrine:
    orm:
        dql:
            string_functions:
                string_agg: Cyber\OrmExtras\Functions\StringAgg
```

> The key **string_agg** in the above configuration will actually be the function name you will have to use in DQL.
>
> You can actually call the function anyway you want, but for purposes of this example it will be **string_agg**

## Sample Usage

The following DQL will aggregate usernames of all users into a single comma delimited field.

```sql
SELECT string_agg(ad.username, \',\' ORDER BY ad.username) FROM Tests\EntityMySql\UserProfile ad
```
