User supplier provides the user object to be used by Creator/Editor/SoftDelted utilities

## Configuration

```yaml
cyber_orm_extras:
    user_supplier: 'service_name'
    user_class:  'YourBundle\Entity\User'
    user_id_field: 'username'
    default_user_id: '5'
```

> To use the default supplier do specify **user_supplier** config.

The default supplier uses the *User* returned by the `token_storage`. If token storage does not have a user, it will
attempt to lookup the default user in the database. The database query will use entity specified by the **user_class** 
configuration, and will attempt to find one who's field specified by **user_id_field** has the value specified by 
**default_user_id**. If no user is found or the corresponding config option are not set, null will be used as value for 
creator/editor values.

> **user_class**, **user_id_field**, and **default_user_id** are used by the default supplier only. So if you have 
> configured a custom supplier service these fields can be omitted.

To replace the default supplier, specify a service name which implements 
`Cyber\OrmExtras\Supplier\CurrentUserSupplier` in **user_supplier** configuration.

## Use Cases

The default user is useful when you have commands or cron jobs inserting/editing entities. In such cases there is no 
user context, so you might want to set the creator/editor as some *system user* account.

> If you do not wish to have a default user and still have cron scripts that create/update these entities you should
> allow *NULL* in the user column definitions.
