<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\OrmExtras\Functions;

use Doctrine\DBAL\Platforms\PostgreSQLPlatform;
use Doctrine\ORM\Query\AST\Functions\FunctionNode;
use Doctrine\ORM\Query\AST\Node;
use Doctrine\ORM\Query\Parser;
use Doctrine\ORM\Query\SqlWalker;
use Doctrine\ORM\Query\TokenType;

class RegexFunction extends FunctionNode
{
    /** @var Node */
    public $fieldExpression;

    /** @var Node */
    public $patternExpression;

    /**
     * @inheritDoc
     */
    public function getSql(SqlWalker $sqlWalker): string
    {
        $platform = $sqlWalker->getConnection()->getDatabasePlatform();

        if($platform instanceof PostgreSQLPlatform) {
            return \sprintf(
                '(%s ~* %s)',
                $this->fieldExpression->dispatch($sqlWalker),
                $this->patternExpression->dispatch($sqlWalker)
            );
        }

        // works for MariaDB, and maybe others
        return \sprintf(
            '(%s REGEXP %s)',
            $this->fieldExpression->dispatch($sqlWalker),
            $this->patternExpression->dispatch($sqlWalker)
        );
    }

    /**
     * @inheritDoc
     */
    public function parse(Parser $parser): void
    {
        $parser->match(TokenType::T_IDENTIFIER);
        $parser->match(TokenType::T_OPEN_PARENTHESIS);

        $this->fieldExpression = $parser->StringPrimary();
        $parser->match(TokenType::T_COMMA);
        $this->patternExpression = $parser->StringPrimary();

        $parser->match(TokenType::T_CLOSE_PARENTHESIS);
    }
}
