<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\OrmExtras\Spec;

use Cyber\OrmExtras\Spec;
use Doctrine\ORM\QueryBuilder;

class OrderBy extends ChildSpec
{
    /**
     * @var array<string, string>
     */
    private $order;

    /**
     * @param array<string, string> $order list of fields to order by on, key is field name value ASC or DESC
     */
    public function __construct(array $order, Spec $child = null)
    {
        parent::__construct($child);
        $this->order = $order;
    }

    /**
     * @inheritDoc
     */
    public function match(QueryBuilder $qb, string $dqlAlias)
    {
        foreach ($this->order as $field => $order) {
            $qb->addOrderBy($dqlAlias . '.' . $field, $order);
        }

        return parent::match($qb, $dqlAlias);
    }
}
