<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\OrmExtras\Spec;

use Cyber\OrmExtras\Spec;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\QueryBuilder;

/**
 * This spec matches using the \Cyber\OrmExtras\Functions\RegexFunction.
 *
 * This spec assumes you registered the above function with name REGEX.
 */
class Regex implements Spec
{
    /** @var int */
    private static $paramIndex = 0;

    public function __construct(private string $field, private string $value)
    {
    }

    /**
     * @inheritDoc
     */
    public function match(QueryBuilder $qb, string $dqlAlias)
    {
        $param = 'spec_regex_' . ++self::$paramIndex;
        $qb->setParameter($param, $this->value);

        return 'REGEX(' . $dqlAlias . '.' . $this->field . ', :' . $param . ') = true';
    }

    /**
     * @inheritDoc
     */
    public function modifyQuery(AbstractQuery $query): void
    {
        // nothing to modify
    }

    /**
     * @inheritDoc
     */
    public function supports(string $className): bool
    {
        // this generic spec supports any entity
        return true;
    }
}
