<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Supplier;

use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * @implements CurrentUserSupplier<UserInterface>
 */
class TokenStorageUserSupplier implements CurrentUserSupplier
{
    private $tokenStorage;

    private $userLoader;

    private $securityContext;

    private $registry;

    /**
     * @param UserLoader<UserInterface> $userLoader
     */
    public function __construct(
        TokenStorageInterface $tokenStorage,
        UserLoader $userLoader,
        AuthorizationCheckerInterface $securityContext,
        ManagerRegistry $registry
    ) {
        $this->tokenStorage    = $tokenStorage;
        $this->userLoader      = $userLoader;
        $this->securityContext = $securityContext;
        $this->registry        = $registry;
    }

    /**
     * @inheritDoc
     */
    public function getCurrentUser()
    {
        $token = $this->tokenStorage->getToken();
        $user  = $token ? $token->getUser() : null;
        if ($user && $this->securityContext->isGranted('IS_AUTHENTICATED_FULLY')
        ) {
            $manager = $this->registry->getManager();
            // check user in doctrine, if not contains merge for managed.
            if (\is_object($user) && !$manager->contains($user)) {
                $className = \get_class($user);
                $class     = $manager->getClassMetadata($className);
                $user      = $manager->find($className, $class->getIdentifierValues($user));
            }

            return $user;
        }

        return $this->userLoader->getDefaultUser();
    }
}
