<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\OrmExtras\Spec;

use Cyber\OrmExtras\Spec;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\QueryBuilder;

class Equals implements Spec
{
    /** @var int */
    private static $paramIndex = 0;

    /** @var string */
    private $field;

    /** @var mixed */
    private $value;

    /**
     * @param string $field
     * @param mixed  $value
     */
    public function __construct(string $field, $value)
    {
        $this->field = $field;
        $this->value = $value;
    }

    /**
     * @inheritDoc
     */
    public function match(QueryBuilder $qb, string $dqlAlias)
    {
        if (null === $this->value) {
            return $qb->expr()->isNull($dqlAlias . '.' . $this->field);
        }

        $param = 'spec_eq_' . ++self::$paramIndex;
        $qb->setParameter($param, $this->value);

        return $qb->expr()->eq($dqlAlias . '.' . $this->field, ':' . $param);
    }

    /**
     * @inheritDoc
     */
    public function modifyQuery(AbstractQuery $query): void
    {
        // nothing to modify
    }

    /**
     * @inheritDoc
     */
    public function supports(string $className): bool
    {
        // this generic spec supports any entity
        return true;
    }
}
