<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\OrmExtras\Mock;

use Cyber\OrmExtras\Spec\EntitySpecRepoTrait;
use Doctrine\ORM\QueryBuilder;

class BasicEntitySpecRepo
{
    use EntitySpecRepoTrait;

    private $queryBuilder;

    private $entityName;

    public function __construct(QueryBuilder $queryBuilder, string $entityName)
    {
        $this->queryBuilder = $queryBuilder;
        $this->entityName   = $entityName;
    }

    public function getEntityName(): string
    {
        return $this->entityName;
    }

    /**
     * @inheritDoc
     *
     * @param string       $alias
     * @param array<mixed> $indexBy
     *
     * @return QueryBuilder
     */
    public function createQueryBuilder($alias, $indexBy = null)
    {
        return $this->queryBuilder;
    }
}
