<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Tests\Cyber\OrmExtras\Supplier;

use Cyber\OrmExtras\Supplier\SupplierConfiguration;
use Cyber\OrmExtras\Supplier\UserLoader;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Persistence\ObjectRepository;
use PHPUnit\Framework\TestCase;
use ReflectionClass;
use Symfony\Component\HttpKernel\KernelInterface;
use Tests\Cyber\OrmExtras\Fixtures\PersonEntity;

/**
 * @internal
 *
 * @covers \Cyber\OrmExtras\Supplier\UserLoader
 */
class UserLoaderTest extends TestCase
{
    /**
     * @SuppressWarnings(PHPMD.StaticAccess)
     */
    public function testUuidNormalization(): void
    {
        $manager      = $this->createMock(ManagerRegistry::class);
        $mockRepo     = $this->createMock(ObjectRepository::class);
        $mockManager  = $this->createMock(EntityManagerInterface::class);
        $mockMetadata = $this->createMock(ClassMetadata::class);
        $kernel       = $this->createMock(KernelInterface::class);

        $kernel->method('isDebug')->willReturnOnConsecutiveCalls(true, false);

        $config     = new SupplierConfiguration(PersonEntity::class, 'id', 'system', []);
        $instance   = new UserLoader($kernel, $config);
        $loaderRef  = new ReflectionClass($instance);
        $fullIdProp = $loaderRef->getProperty('fullUserId');
        $fullIdProp->setAccessible(true);

        $instance->setDoctrine($manager);

        $user     = new PersonEntity();
        $expected = [57348, 'somestr_part'];
        $manager->method('getRepository')->willReturn($mockRepo);
        $mockRepo->method('findOneBy')->willReturn($user);
        $manager->method('getManager')->willReturn($mockManager);
        $mockManager->method('getClassMetadata')->willReturn($mockMetadata);
        $mockMetadata->method('getIdentifierValues')->willReturn($expected);

        $instance->load();
        static::assertTrue($instance->isLoaded());
        static::assertEquals($expected, $fullIdProp->getValue($instance));

        $instance = new UserLoader($kernel, $config);
        $instance->setDoctrine($manager);

        // this time should load from cache file
        $instance->load();
        static::assertTrue($instance->isLoaded());
        static::assertEquals($expected, $fullIdProp->getValue($instance));
    }
}
