<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Event;

use Cyber\OrmExtras\Supplier\CurrentUserSupplier;
use Cyber\OrmExtras\Utility\SoftDeletable;
use DateTime;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsDoctrineListener;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Events;
use Symfony\Component\Security\Core\User\UserInterface;

#[AsDoctrineListener(event: Events::preFlush)]
class SoftDeleteLifecycleListener
{
    /** @var CurrentUserSupplier<UserInterface> */
    private $userSupplier;

    /**
     * @param CurrentUserSupplier<UserInterface> $userSupplier
     */
    public function __construct(CurrentUserSupplier $userSupplier)
    {
        $this->userSupplier = $userSupplier;
    }

    /**
     * @param PreFlushEventArgs $event
     *
     * @throws \Doctrine\ORM\Exception\ORMException
     */
    public function preFlush(PreFlushEventArgs $event): void
    {
        $em          = $event->getObjectManager();

        $uow = $em->getUnitOfWork();

        foreach ($uow->getScheduledEntityDeletions() as $object) {
            if ($object instanceof SoftDeletable) {
                if ($object->getForceDelete() || null !== $object->getDateDeleted()) {
                    continue;
                }

                $object->setDateDeleted(new DateTime());
                $object->setUserDeleted($this->userSupplier->getCurrentUser());
                $em->persist($object);
            }
        }
    }
}
