<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\OrmExtras\Spec;

use Cyber\OrmExtras\Spec;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\QueryBuilder;

/**
 * A helper class for implementing specs that require a child spec.
 */
abstract class ChildSpec implements Spec
{
    /** @var null|Spec */
    protected $childSpec;

    public function __construct(Spec $child = null)
    {
        $this->childSpec = $child;
    }

    /**
     * @inheritDoc
     */
    public function match(QueryBuilder $qb, string $dqlAlias)
    {
        if (!$this->childSpec) {
            return null;
        }

        return $this->childSpec->match($qb, $dqlAlias);
    }

    /**
     * @inheritDoc
     */
    public function modifyQuery(AbstractQuery $query): void
    {
        if (!$this->childSpec) {
            return;
        }

        $this->childSpec->modifyQuery($query);
    }

    /**
     * @inheritDoc
     */
    public function supports(string $className): bool
    {
        if (!$this->childSpec) {
            return true;
        }

        return $this->childSpec->supports($className);
    }
}
