<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

use DateTimeInterface;

/**
 * @template T
 */
interface CreatorAttributes
{
    /**
     * Returns properties that should be updated in a cascade when this entity is created.
     *
     * @return CreatorAttributes<T>[]
     */
    public function getCreatorCascade(): array;

    /**
     * returns the user who created this entity.
     *
     * @return null|T
     */
    public function getUserCreated();

    /**
     * sets the user who created this entity.
     *
     * @param T $user the user that created this entity
     *
     * @return $this
     */
    public function setUserCreated($user): self;

    /**
     * returns the date of the creation.
     *
     * @return null|DateTimeInterface
     */
    public function getDateCreated(): ?DateTimeInterface;

    /**
     * sets the date of the creation.
     *
     * @param DateTimeInterface $date
     *
     * @return $this
     */
    public function setDateCreated(DateTimeInterface $date): self;
}
