<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\UploadBundle\Event;

use Cyber\UploadBundle\Component\HandlerInterface;
use Cyber\UploadBundle\Component\UploadHolder;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Psr\Log\LoggerInterface;

class UploadEntityLifecycleSubscriber implements EventSubscriber
{
    private $handler;

    /**
     * @var null|LoggerInterface
     */
    private $logger;

    public function __construct(HandlerInterface $handler, LoggerInterface $logger = null)
    {
        $this->handler = $handler;
        $this->logger  = $logger;
    }

    public function postPersist(LifecycleEventArgs $args): void
    {
        $this->upload($args);
    }

    public function postUpdate(LifecycleEventArgs $args): void
    {
        $this->upload($args);
    }

    public function upload(LifecycleEventArgs $args): void
    {
        $entity = $args->getEntity();
        if (!$entity instanceof UploadHolder) {
            return;
        }

        try {
            $this->handler->upload($entity);
        } catch (\Throwable $ex) {
            if ($this->logger) {
                $this->logger->critical('Upload handler failed to upload file: ' . $ex->getMessage(), ['exception' => $ex]);
            }
        }
    }

    /**
     * Returns an array of events this subscriber wants to listen to.
     *
     * @return string[]
     */
    public function getSubscribedEvents(): array
    {
        return [
            'postPersist',
            'postUpdate',
        ];
    }
}
