<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\UploadBundle\DependencyInjection;

use Cyber\UploadBundle\DependencyInjection\Configuration;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Config\Definition\ArrayNode;

class ConfigurationTest extends TestCase
{
    public function testGetConfigTreeBuilder(): void
    {
        $config = new Configuration();

        $treeBuilder = $config->getConfigTreeBuilder();

        /** @var ArrayNode $tree */
        $tree = $treeBuilder->buildTree();

        $this->assertEquals('cyber_upload', $tree->getName());

        $children = $tree->getChildren();

        $this->assertCount(6, $children);
        $this->assertArrayHasKey('handler', $children);
        $this->assertArrayHasKey('aws', $children);
        $this->assertArrayHasKey('local', $children);
        $this->assertArrayHasKey('service', $children);
        $this->assertArrayHasKey('mapping', $children);
        $this->assertArrayHasKey('naming_strategy', $children);
    }
}
