<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\UploadBundle\Component\Handler;

use Cyber\UploadBundle\Component\HandlerInterface;
use Cyber\UploadBundle\Component\UploadHolder;

/**
 * Handler for just ignoring the uploads.
 *
 * Could be useful in testing environment.
 */
class NoOpHandler implements HandlerInterface
{
    /**
     * {@inheritdoc}
     */
    public function upload(UploadHolder $uploadEntity): void
    {
        // do nothing
    }

    /**
     * {@inheritdoc}
     */
    public function delete(UploadHolder $uploadEntity): void
    {
        // do nothing
    }

    /**
     * {@inheritdoc}
     */
    public function copy(UploadHolder $src, UploadHolder $dst): void
    {
        // do more of nothing
    }

    /**
     * {@inheritdoc}
     */
    public function getURL(UploadHolder $uploadEntity, array $options = []): string
    {
        return '/dev/null';
    }

    /**
     * {@inheritdoc}
     */
    public function exists(UploadHolder $uploadEntity): bool
    {
        return false;
    }

    /**
     * {@inheritdoc}
     */
    public function import(string $fromUrl, UploadHolder $destination): void
    {
        // do nothing
    }
}
