<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\UploadBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\NodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('cyber_upload');

        /** @var ArrayNodeDefinition|NodeDefinition $rootNode */
        $rootNode = $treeBuilder->getRootNode();

        $rootNode
            ->children()
                ->enumNode('handler')
                    ->values(['aws', 'service', 'local', 'noop'])
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->arrayNode('aws')
                    ->info('when handler is \'aws\' these parameters are required, none should be empty')
                    ->children()
                        ->scalarNode('bucket')
                            ->info('the bucket where uploads will be stored')
                        ->end()
                        ->scalarNode('path')
                            ->info('the path inside the bucket where uploads will be stored')
                            ->example('company/uploads')
                        ->end()
                        ->scalarNode('key')
                            ->info('the key used for authentication with S3')
                            ->isRequired()
                            ->cannotBeEmpty()
                        ->end()
                        ->scalarNode('secret')
                            ->info('the secret used for authentication with S3')
                            ->isRequired()
                            ->cannotBeEmpty()
                        ->end()
                    ->end()
                ->end()//aws
                ->arrayNode('local')
                    ->info('when handler is "local" these parameters are required')
                    ->children()
                        ->scalarNode('path')
                            ->info('Absolute path to store the files in')
                            ->cannotBeEmpty()
                        ->end()
                    ->end()
                ->end()//local
                ->enumNode('naming_strategy')
                    ->values(['entity_id', 'file_name'])
                    ->defaultValue('file_name')
                ->end() // naming_strategy
                ->scalarNode('service')
                    ->info('When handler is "service" the service id should be specified here')
                ->end()
                ->arrayNode('mapping')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('class')
                                ->info('Fully qualified class name to map to a path below')
                                ->cannotBeEmpty()
                            ->end()
                            ->scalarNode('path')
                                ->info('The storage path the above class is mapped to')
                                ->cannotBeEmpty()
                            ->end()
                        ->end()
                    ->end()
                ->end() //mapping
            ->end()
        ;

        return $treeBuilder;
    }
}
