<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\UploadBundle\Event;

use Cyber\UploadBundle\Component\HandlerInterface;
use Cyber\UploadBundle\Component\UploadHolder;
use Cyber\UploadBundle\Event\UploadEntityLifecycleSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;

class UploadEntityLifecycleSubscriberTest extends TestCase
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /** @var HandlerInterface|\PHPUnit_Framework_MockObject_MockObject */
    private $handler;

    protected function setUp(): void
    {
        $this->container = $this->mockContainer();
        $this->handler   = $this->mockHandlerInterface();
    }

    public function testUpload(): void
    {
        $this->handler->expects($this->once())
            ->method('upload');

        $lifecycleSubscriber = new UploadEntityLifecycleSubscriber($this->handler);
        $lifecycleSubscriber->upload($this->mockLifecycleEventArgs());
    }

    public function testPostPersist(): void
    {
        $this->handler->expects($this->once())
            ->method('upload');

        $lifecycleSubscriber = new UploadEntityLifecycleSubscriber($this->handler);
        $lifecycleSubscriber->postPersist($this->mockLifecycleEventArgs());
    }

    public function testPostUpdate(): void
    {
        $this->handler->expects($this->once())
            ->method('upload');

        $lifecycleSubscriber = new UploadEntityLifecycleSubscriber($this->handler);
        $lifecycleSubscriber->postUpdate($this->mockLifecycleEventArgs());
    }

    public function testGetSubscribedEvents(): void
    {
        $lifecycleSubscriber = new UploadEntityLifecycleSubscriber($this->mockHandlerInterface());
        $result              = $lifecycleSubscriber->getSubscribedEvents();
        $this->assertEquals([
            'postPersist',
            'postUpdate',
        ], $result);
    }

    /**
     * Mock an Container Object.
     *
     * @return ContainerInterface|MockObject
     */
    private function mockContainer()
    {
        /** @var ContainerInterface|MockObject $container */
        $container = $this->getMockBuilder('Symfony\\Component\\DependencyInjection\\Container')
            ->disableOriginalConstructor()
            ->getMock();

        return $container;
    }

    /**
     * Mock an LifecycleEventArgs Object.
     *
     * @return LifecycleEventArgs|MockObject
     */
    private function mockLifecycleEventArgs()
    {
        /** @var LifecycleEventArgs|MockObject $lifecycleEventArgs */
        $lifecycleEventArgs = $this->getMockBuilder('Doctrine\\ORM\\Event\\LifecycleEventArgs')
            ->disableOriginalConstructor()
            ->getMock();

        $lifecycleEventArgs->expects($this->any())
            ->method('getEntity')
            ->willReturn($this->mockUploadEntityInterface());

        return $lifecycleEventArgs;
    }

    /**
     * @return HandlerInterface|MockObject
     */
    private function mockHandlerInterface()
    {
        /** @var HandlerInterface|MockObject $handlerInterface */
        $handlerInterface = $this->getMockBuilder('Cyber\\UploadBundle\\Component\\HandlerInterface')
            ->disableOriginalConstructor()
            ->getMock();

        return $handlerInterface;
    }

    /**
     * @return UploadHolder
     */
    private function mockUploadEntityInterface(): UploadHolder
    {
        $mock = $this->getMockBuilder(UploadHolder::class)
            ->disableOriginalConstructor()
            ->getMock();

        return $mock;
    }
}
