<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\UploadBundle\Component;

use Symfony\Component\HttpFoundation\File\UploadedFile;

/**
 * @deprecated since 3.3 use Cyber\UploadBundle\Component\UploadHolder instead.
 */
interface UploadEntity
{
    /**
     * Returns unique id of the entity of type integer.
     *
     * @return null|int
     */
    public function getId(): ?int;

    /**
     * Return file.
     *
     * @return null|UploadedFile
     */
    public function getFile(): ?UploadedFile;

    /**
     * Return expansion file.
     *
     * @return string
     */
    public function getExt(): string;

    /**
     * If this function returns true during upload, the uploaded file will be downloadable to anyone with a link
     * without need for creating a signed request.
     *
     * @return bool true for files which should be publicly accessible
     *
     * @SuppressWarnings(PHPMD.BooleanGetMethodName)
     */
    public function getPublic(): bool;

    /**
     * Returns the filename.
     *
     * Used to set the name of the file that will encoded in the url for download.
     *
     * @return string
     */
    public function getName(): string;
}
