<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\UploadBundle\Entity;

use Cyber\UploadBundle\Component\UploadHolder;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class MockUpload implements UploadHolder
{
    private $id;

    /** @var null|UploadedFile */
    private $file;

    public function __construct(int $id)
    {
        $this->id = $id;
    }

    /**
     * @inheritdoc
     */
    public function getStorageSlug()
    {
        return $this->id;
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getName(): string
    {
        return 'theFirstFile';
    }

    public function getFile(): ?UploadedFile
    {
        return $this->file;
    }

    public function setFile(UploadedFile $file = null): void
    {
        $this->file = $file;
    }

    public function getExt(): string
    {
        return 'txt';
    }

    public function getPublic(): bool
    {
        return true;
    }
}
