<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\UploadBundle\Component;

use RuntimeException;
use Throwable;

/**
 * An exception thrown file handlers when any errors occur.
 */
class HandlerException extends RuntimeException
{
    /** @var null|UploadHolder */
    private $uploadEntity;

    /**
     * @param string            $message
     * @param null|UploadHolder $entity
     * @param null|Throwable    $previous
     */
    public function __construct($message = '', $entity = null, Throwable $previous = null)
    {
        parent::__construct($message, 0, $previous);

        $this->uploadEntity = $entity;
    }

    /**
     * @return null|UploadHolder
     */
    public function getUploadEntity(): ?UploadHolder
    {
        return $this->uploadEntity;
    }
}
