<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\UploadBundle\Event;

use Cyber\UploadBundle\Component\HandlerException;
use Cyber\UploadBundle\Component\HandlerInterface;
use Cyber\UploadBundle\Component\UploadHolder;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsDoctrineListener;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Events;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Psr\Log\LoggerInterface;

#[AsDoctrineListener(event: Events::postRemove)]
class UploadCleanupLifecycleListener
{
    /** @var HandlerInterface */
    private $handler;

    /**
     * @var null|LoggerInterface
     */
    private $logger;

    public function __construct(HandlerInterface $handler, LoggerInterface $logger = null)
    {
        $this->handler = $handler;
        $this->logger  = $logger;
    }

    /**
     * @param PostRemoveEventArgs $args for ORM V2 must keep LifecycleEventArgs as argument type
     */
    public function postRemove(LifecycleEventArgs $args): void
    {
        $entity = $args->getObject();

        if (!$entity instanceof UploadHolder) {
            return;
        }

        try {
            $this->handler->delete($entity);
        } catch (HandlerException $ex) {
            if ($this->logger) {
                $this->logger->warning(
                    \sprintf('Failed to delete file associated with UploadHolder slug "%s"', $entity->getStorageSlug()),
                    ['exception', $ex]
                );
            }
        }
    }
}
