<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\UploadBundle\Twig;

use Cyber\UploadBundle\Component\HandlerInterface;
use Cyber\UploadBundle\Component\UploadHolder;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class UploadExtension extends AbstractExtension
{
    private $handler;

    public function __construct(HandlerInterface $handler)
    {
        $this->handler = $handler;
    }

    /**
     * @return TwigFunction[]
     */
    public function getFunctions(): array
    {
        return [new TwigFunction('cyber_upload_url', [$this, 'getUrl'])];
    }

    /**
     * use {{ cyber_upload_url($uploadEntity) }}.
     *
     * @param null|UploadHolder $uploadEntity
     * @param array<mixed>      $options
     *
     * @return string
     */
    public function getUrl($uploadEntity, $options = []): string
    {
        if (null === $uploadEntity) {
            return '#';
        }

        return $this->handler->getURL($uploadEntity, $options);
    }

    public function getName(): string
    {
        return 'cyber_upload_extension';
    }
}
