<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\UploadBundle\Component;

class PathResolver
{
    private $mapping;

    /**
     * PathResolver constructor.
     *
     * @param string[] $mapping
     */
    public function __construct($mapping)
    {
        $this->mapping    = $mapping ?: [];
    }

    /**
     * @param object $entity
     *
     * @return string
     */
    public function resolve($entity): string
    {
        foreach ($this->mapping as $className => $path) {
            if (\is_a($entity, $className)) {
                return $path;
            }
        }

        return \md5(\get_class($entity));
    }
}
