<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\UploadBundle\Twig;

use Cyber\UploadBundle\Component\HandlerInterface;
use Cyber\UploadBundle\Component\UploadHolder;
use Cyber\UploadBundle\Twig\UploadExtension;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Twig\TwigFunction;

/**
 * @internal
 *
 * @coversNothing
 */
class UploadExtensionTest extends TestCase
{
    /** @var HandlerInterface|MockObject */
    private $mockHandler;

    public function setUp(): void
    {
        $this->mockHandler = $this->getMockBuilder(HandlerInterface::class)
            ->getMock();
    }

    public function testGetFunctions(): void
    {
        $twig = new UploadExtension($this->mockHandler);
        /** @var TwigFunction[] $funcs */
        $funcs = $twig->getFunctions();
        static::assertNotEmpty($funcs);

        $hasCyberS3Url = false;

        foreach ($funcs as $func) {
            if ('cyber_upload_url' === $func->getName()) {
                $hasCyberS3Url = true;
                break;
            }
        }
        static::assertTrue($hasCyberS3Url);
    }

    /**
     * @dataProvider getUrlProvider
     *
     * @param null|UploadHolder $entity
     *
     * @SuppressWarnings(PHPMD.ElseExpression)
     */
    public function testGetUrl($entity): void
    {
        if ($entity) {
            $expected = 'zzz';

            $this->mockHandler->expects(static::once())
                ->method('getURL')
                ->with($entity)
                ->willReturn($expected);
        } else {
            $expected = '#';
        }

        $twig = new UploadExtension($this->mockHandler);
        $url  = $twig->getUrl($entity);
        static::assertEquals($expected, $url);
    }

    /**
     * @return array<mixed>
     */
    public function getUrlProvider(): array
    {
        $entity = $this->getMockBuilder(UploadHolder::class)
            ->getMock();

        return [
            [$entity],
            [null],
        ];
    }

    public function testGetName(): void
    {
        $twig = new UploadExtension($this->mockHandler);
        static::assertEquals('cyber_upload_extension', $twig->getName());
    }
}
