<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\UploadBundle\DependencyInjection;

use Cyber\UploadBundle\CyberUploadBundle;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Config\Definition\ArrayNode;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\Configurator\DefinitionConfigurator;
use Symfony\Component\Config\Definition\Loader\DefinitionFileLoader;

/**
 * @internal
 *
 * @coversNothing
 */
class ConfigurationTest extends TestCase
{
    public function testGetConfigTreeBuilder(): void
    {
        $loader      = $this->createMock(DefinitionFileLoader::class);
        $treeBuilder = new TreeBuilder('cyber_upload');
        $definition  = new DefinitionConfigurator($treeBuilder, $loader, '', '');
        $bundle      = new CyberUploadBundle();
        $bundle->configure($definition);

        /** @var ArrayNode $tree */
        $tree = $definition->rootNode()->getNode(true);

        static::assertEquals('cyber_upload', $tree->getName());

        $children = $tree->getChildren();

        static::assertCount(6, $children);
        static::assertArrayHasKey('handler', $children);
        static::assertArrayHasKey('aws', $children);
        static::assertArrayHasKey('local', $children);
        static::assertArrayHasKey('service', $children);
        static::assertArrayHasKey('mapping', $children);
        static::assertArrayHasKey('naming_strategy', $children);
    }
}
