<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Aws\S3\S3Client;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->services()
        ->set('cyber.upload.s3client', S3Client::class)
            ->args([
                [
                    'region'      => 'us-east-1',
                    'version'     => 'latest',
                    'credentials' => [
                        'key'    => param('cyber.upload.key'),
                        'secret' => param('cyber.upload.secret'),
                    ],
                ],
            ])
    ;
    // @formatter:on
};
