<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Cyber\UploadBundle\Component\HandlerInterface;
use Cyber\UploadBundle\Component\PathResolver;
use Cyber\UploadBundle\Event\UploadCleanupLifecycleListener;
use Cyber\UploadBundle\Event\UploadEntityLifecycleListener;
use Cyber\UploadBundle\Twig\UploadExtension;
use Doctrine\ORM\Events;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->parameters()
        ->set('cyber.upload.key', null)
        ->set('cyber.upload.secret', null)
        ->set('cyber.upload.mapping', null);

    $container->services()
        ->set('cyber_upload.path.resolver', PathResolver::class)
            ->args([
                param('cyber.upload.mapping'),
            ])
        ->alias(PathResolver::class, 'cyber_upload.path.resolver')

        ->set('cyber_upload.entity.lifecycle_listener', UploadEntityLifecycleListener::class)
        ->args([
            service('cyber_upload.file.handler'),
            service('logger')->nullOnInvalid(),
        ])
        ->tag('doctrine.event_listener', ['event' => Events::postPersist])
        ->tag('doctrine.event_listener', ['event' => Events::postUpdate])
        ->alias(UploadEntityLifecycleListener::class, 'cyber_upload.entity.lifecycle_listener')

        ->set('cyber_upload.cleanup.lifecycle_listener', UploadCleanupLifecycleListener::class)
        ->args([
            service('cyber_upload.file.handler'),
            service('logger')->nullOnInvalid(),
        ])
        ->tag('doctrine.event_listener', ['event' => Events::postRemove])
        ->alias(UploadCleanupLifecycleListener::class, 'cyber_upload.cleanup.lifecycle_listener')

        ->set('cyber_upload.twig.extension', UploadExtension::class)
        ->args([
            service('cyber_upload.file.handler'),
        ])
        ->tag('twig.extension')
        ->alias(UploadExtension::class, 'cyber_upload.twig.extension')

        // extra aliases
        ->alias(HandlerInterface::class, 'cyber_upload.file.handler')
    ;
    // @formatter:on
};
