Here is a sample entity implementing `UploadHolder`. Fields `id` and `ext` are crucial as they are required
to later fetch the uploaded file from its storage location. Also note that `file` field does not have `Column`
attribute as it does not need to be stored in the database. This field is used to only temporarily store the uploaded
file.

If `file` field is null, our handle will simply skip the upload process, thus allowing you to change any other fields
in the entity and persist it without having user upload the file each time.

> You should never change the values returned by `getStorageSlug()` or `getExt()` once the file has been uploaded.

```php
<?php
use Cyber\UploadBundle\Component\UploadHolder;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class Upload implements UploadHolder
{
    #[ORM\Column(name: "upl_id", type: "integer")]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: "AUTO")]
    private $id;

    /**
     * @var string for storing original filename
     */
     #[ORM\Column(name: "upl_name", type: "string", length: 30, nullable: false)]
    private $name;

    /**
     * @var string extension of the uploaded file
     */
     #[ORM\Column(name: "upl_ext", type: "string", length: 7, nullable: false)]
    private $ext;
    
    /**
     * @var string extension of the uploaded file
     */
     #[ORM\Column(name: "upl_public", type: "boolean")]
    private $public;

    /**
     * @var UploadedFile temporary storage of the UploadedFile object coming from forms. 
     *                   
     * This should NOT be mapped to DB.          
     */
    private $file;
   
    public function getStorageSlug()
    {
        return $this->id;
    }

    public function getId()
    {
        return $this->id;
    }
    
    public function getExt(): string
    {
        return $this->ext;
    }

    public function getFile(): ?UploadedFile
    {
        return $this->file;
    }
    
    public function getPublic(): bool 
    {
        return $this->public;
    }
    
    public function getName(): string
    {
        return $this->name;
    }
        
    public function setFile(UploadedFile $file = null)
    {
        $this->file = $file;

        return $this;
    }
    
    //other setters/getters
    
}
```
