<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\UploadBundle\Event;

use Cyber\UploadBundle\Component\HandlerInterface;
use Cyber\UploadBundle\Component\UploadHolder;
use Cyber\UploadBundle\Event\UploadEntityLifecycleListener;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Event\PostPersistEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * @internal
 *
 * @covers \Cyber\UploadBundle\Event\UploadEntityLifecycleListener
 */
class UploadEntityLifecycleListenerTest extends TestCase
{
    /** @var HandlerInterface|MockObject */
    private $handler;

    protected function setUp(): void
    {
        $this->handler   = $this->mockHandlerInterface();
    }

    public function testUpload(): void
    {
        $this->handler->expects(static::once())
            ->method('upload');

        $lifecycleSubscriber = new UploadEntityLifecycleListener($this->handler);
        $lifecycleSubscriber->upload($this->mockLifecycleEventArgs(PostUpdateEventArgs::class));
    }

    public function testPostPersist(): void
    {
        $this->handler->expects(static::once())
            ->method('upload');

        $lifecycleSubscriber = new UploadEntityLifecycleListener($this->handler);
        $lifecycleSubscriber->postPersist($this->mockLifecycleEventArgs(PostPersistEventArgs::class));
    }

    public function testPostUpdate(): void
    {
        $this->handler->expects(static::once())
            ->method('upload');

        $lifecycleSubscriber = new UploadEntityLifecycleListener($this->handler);
        $lifecycleSubscriber->postUpdate($this->mockLifecycleEventArgs(PostUpdateEventArgs::class));
    }

    /**
     * Mock an LifecycleEventArgs Object.
     *
     * @template T of LifecycleEventArgs
     *
     * @param class-string<T> $class
     *
     * @return T
     */
    private function mockLifecycleEventArgs(string $class)
    {
        return new $class($this->mockUploadEntityInterface(), $this->createMock(EntityManagerInterface::class));
    }

    /**
     * @return HandlerInterface|MockObject
     */
    private function mockHandlerInterface()
    {
        /** @var HandlerInterface|MockObject $handlerInterface */
        $handlerInterface = $this->getMockBuilder('Cyber\\UploadBundle\\Component\\HandlerInterface')
            ->disableOriginalConstructor()
            ->getMock();

        return $handlerInterface;
    }

    /**
     * @return UploadHolder
     */
    private function mockUploadEntityInterface(): UploadHolder
    {
        $mock = $this->getMockBuilder(UploadHolder::class)
            ->disableOriginalConstructor()
            ->getMock();

        return $mock;
    }
}
